/*linkplus plugin light edition 用 config
*/

jQuery.noConflict();

(function(pluginId, $) {
    "use strict";

	var MAX_BUTTON_COUNT = 1;//default最大数 lightは2つまで
	var button_count = 1;//最初は1つ用意しておく

	$(document).ready(function() {
 
 	   	//既に値が設定されている場合はフィールドに値を設定する
        $("#linkp_config_label").text("ライト版はボタン１つのみです。2つ以上必要な方は通常版をどうぞ！");

 	  	var conf = kintone.plugin.app.getConfig(pluginId);
		if (conf){
			button_count = Number(conf['button_count']);//定義済みのボタン数

			for(var i=0;i < button_count;i++){ 
	            $("#linkp-config-tbody > tr").eq(0).clone(true).insertAfter($("#linkp-config-tbody > tr").eq(i));
				$('.linkp-button-label').eq(i+1).val(conf['button_label'+i]);
	 	  		$('.linkp-button-link').eq(i+1).val(conf['button_link'+i]);
	 	  		$('.linkp-button-target').eq(i+1).val(conf['button_target'+i]);

				}
			} 

		buildconfig();

		function buildconfig(){
			var len = $("#linkp-config-tbody > tr").length-1;

			if(len == 0) { //初期状態なので1行入力行を追加しておく
	            $("#linkp-config-tbody > tr").eq(0).clone(true).insertAfter("#linkp-config-tbody > tr");
				//$(".removeList").eq(1).hide();
				//$(".addList").eq(1).hide();
                //return; //一個だけなのでこれ以上はなにもしない
                ++len;
                }    
			if(len == 1) { //1行しかない場合 削除を無効にする 1行目は非表示なので+1
				$(".removeList").eq(1).hide();
			    } 
            if(len==MAX_BUTTON_COUNT){ //最大行の場合は、追加を無効にする
				$(".addList").each(function() {
					$(this).hide();
				})
			} else {
				$(".addList").each(function() {
					$(this).show();
				})
				$(".removeList").each(function() {
					$(this).show();
				})
				
			}
		}

       //一行追加
        $("#linkp-config-tbody .addList").click(function() {
            $("#linkp-config-tbody > tr").eq(0).clone(true).insertAfter($(this).parent().parent());
            buildconfig();
        });

        // 一行削除
        $(".removeList").click(function() {
            $(this).parent('td').parent('tr').remove();
            buildconfig();
        });

		/*Sortable １つしかないので無効
		$("#linkp-config-tbody").sortable(
			{handle:".linkp-updown-image"}
		);
        */
        
		//「保存する」ボタン押下時に入力情報を設定する
		$('#submit').click(function() {
			var config = [];
			button_count=0;
			var len = $("#linkp-config-tbody > tr").length-1;

			for(var i=0;i < len;i++){ //配列が使えないので疑似インデックスで処理
				var label = $('.linkp-button-label').eq(i+1).val();
				var link = $('.linkp-button-link').eq(i+1).val();
				var target = $('.linkp-button-target').eq(i+1).val();

				if ((label =="" ||  link =="") ){ //必須項目のどちらかがなかったらアラート
    	      		alert((i+1)+"行目の必須項目が入力されていません");
		  	 		return;
        			}

	 		  	config['button_label'+i] = label;
	 	  		config['button_link'+i] = link;
	 	  		config['button_target'+i] = target;
				button_count++;

			}
			config['button_count'] = String(button_count);
			kintone.plugin.app.setConfig(config);
			});
     
		//「キャンセル」ボタン押下時の処理
		$('#cancel').click(function() {
            history.back();
    	});
    });
})(kintone.$PLUGIN_ID, jQuery);
