//linkplus plugin for kintone
//since 2017/6/4
//last modified 2017/6/4

jQuery.noConflict();

(function ($,PLUGIN_ID) {
  
    "use strict";
    
    var button_count = 0;//ボタンの総数
    var config = [];//config       
    // 詳細画面に郵便番号検索用のボタンを設置します
    function linkplus(event){
         
        // プラグインIDの設定
        var KEY = PLUGIN_ID;
         
        //config 読み込み
        config = kintone.plugin.app.getConfig(KEY);
         
        //設定値読み込み
        if (!config) return false;

        var mybuttonclass = "mmym-linkp-button";
        button_count = Number(config["button_count"]);

       //一覧画面のヘッダー部分要素を取得
		var se = kintone.app.getHeaderMenuSpaceElement();
		if (!se) return false;

        for(var i=0;i < button_count; i++) {
            //ボタンidの決め
            var btn_id = mybuttonclass + KEY + i; //PLUGIN_IDでidをユニークに 

            if (document.getElementById(btn_id) !== null) continue; //既に登録済みならスキップ

     		//ボタンの作成
    		var btn = document.createElement('button');
    		btn.id = btn_id;
    		btn.name = btn_id;
            btn.className = mybuttonclass;
            btn.setAttribute('formaction',config["button_link"+i]);//リンク情報セット
            btn.setAttribute('formtarget',config["button_target"+i]);//target属性セット

    		btn.appendChild(document.createTextNode(config["button_label"+i]));
    		se.appendChild(btn);
            }

        $("."+mybuttonclass).on("click",function(){
            if($(this).attr('formtarget') != '_blank') location.href=$(this).attr('formaction');
            else window.open($(this).attr('formaction'),"_blank");
            });
        return event;
  
    }
  
    // 登録・更新イベント(新規レコード、編集レコード、一覧上の編集レコード)
    kintone.events.on('app.record.index.show', linkplus);
  
})(jQuery,kintone.$PLUGIN_ID);