jQuery.noConflict();

(function(pluginId, $) {
    "use strict";

    $(document).ready(function() {
        kintone.api(kintone.api.url('/k/v1/preview/app/form/layout', true), 'GET', { //スペース情報を取得する
            'app': kintone.app.getId()
        }, function(resp) {
            $.each(resp['layout'], function(index, layout) {
	            switch(layout['type']) {
		            case 'GROUP'://グループの場合
						$.each(layout['layout'],function(subindex,sublayout) {
							$.each(sublayout['fields'],function(fieldindex,field) {
  							switch(field['type']) {
							case 'SPACER':
					   			$('#zipp_btn_code').append($('<OPTION>').html(field['elementId']).val(field['elementId']));
								break;
							  }

							})
						})
						break;
					default:
						$.each(layout['fields'],function(fieldindex,field) {
  							switch(field['type']) {
							case 'SPACER':
					   			$('#zipp_btn_code').append($('<OPTION>').html(field['elementId']).val(field['elementId']));
								break;
							  }

							})
					break;
					}
	            });
			});
				
		kintone.api(kintone.api.url('/k/v1/preview/form', true), 'GET', { //グループ以外のフォーム情報を取得する
            'app': kintone.app.getId()
        }, function(resp) {
            $.each(resp['properties'], function(index, property) {
	            switch(property['type']) {
		            case 'NUMBER':
	                    $('#zipp_zip_code').append($('<OPTION>').html(property['label']).val(property['code']));
						break;
		            case 'SINGLE_LINE_TEXT':
	                    $('#zipp_zip_code').append($('<OPTION>').html(property['label']).val(property['code']));
	                    $('#zipp_addr_code').append($('<OPTION>').html(property['label']).val(property['code']));
	                    $('#zipp_state_code').append($('<OPTION>').html(property['label']).val(property['code']));
	                    $('#zipp_city_code').append($('<OPTION>').html(property['label']).val(property['code']));
						$('#zipp_company_code').append($('<OPTION>').html(property['label']).val(property['code']));
						break;
					case 'DROP_DOWN':
	                    $('#zipp_state_code').append($('<OPTION>').html(property['label']).val(property['code']));
						break;

						
	            }
            });

        //既に値が設定されている場合はフィールドに値を設定する
        var conf = kintone.plugin.app.getConfig(pluginId);
		if (conf){
     	  	$('#zipp_zip_code').val(conf['zip']);
	 	  	$('#zipp_addr_code').val(conf['addr']);
	 	  	$('#zipp_state_code').val(conf['state']);
	 	  	$('#zipp_city_code').val(conf['city']);
			$('#zipp_company_code').val(conf['company']);
	 	  	$('#zipp_btn_code').val(conf['btn']);
			if(!conf['btn_text']) {
				$('#zipp_btn_text').val("検索");
			} else {
		 		$('#zipp_btn_text').val(conf['btn_text']);
			}

	 	   $('#zipp_state_text').val(conf['state_text']);
	 	   if( conf['without_state'] == "all") {
		 	   $('#zipp_without_state').prop('checked',true);
		 	   }
			
	 	   if( conf['newdesign'] == "on") {
		 	   $('#zipp_newdesign').prop('checked',true);
		 	   }
			}
		});


		//「保存する」ボタン押下時に入力情報を設定する
		$('#submit').click(function() {
     	   var config = [];
	 	   var zip = $('#zipp_zip_code').val();
	 	   var addr = $('#zipp_addr_code').val();
	 	   var state = $('#zipp_state_code').val();
	 	   var city = $('#zipp_city_code').val();
	 	   var btn = $('#zipp_btn_code').val();
	 	   var company = $('#zipp_company_code').val();
	 	   var btn_text = $('#zipp_btn_text').val();
	 	   var state_text = $('#zipp_state_text').val();
	 	   var without_state = "";
		   var newdesign = "";
	 	   if($('#zipp_without_state').prop('checked')) without_state = "all"; 
	 	   if($('#zipp_newdesign').prop('checked')) newdesign = "on"; 

	 	   if (zip =="" ||  addr =="" || btn_text =="" || btn ==""){
          	  alert("必須項目が入力されていません");
		  	  return;
        	}
			config['zip'] = zip;
			config['addr'] = addr;
			config['state'] = state;
			config['city'] = city;
			config['company'] = company;
			config['btn'] = btn;
			config['btn_text'] = btn_text;
			config['state_text'] = state_text;
			config['without_state'] = without_state;
			config['newdesign'] = newdesign;
 
			kintone.plugin.app.setConfig(config);
			});
     
		//「キャンセル」ボタン押下時の処理
		$('#cancel').click(function() {
            history.back();
    	});
    });
})(kintone.$PLUGIN_ID, jQuery);
