//zipplus plugin js-file
//since 2015/01/12
//last modified 2016/8/5

jQuery.noConflict();

(function ($,PLUGIN_ID) {
  
    "use strict";
    
    var zip_field;//
    var addr_field;
    var state_field;
    var city_field;
    var company_field;
    var state_text;
    var without_state;
    var zip_api = 'https://madefor.github.io/postal-code-api/api/v1/';
   
    //郵便番号から住所へ　madefor利用
	function zip_to_addr() {

		var record = kintone.app.record.get();	
		var zip = record["record"][zip_field]["value"];
        var tar_zip = []; //

		if(zip === ''){
            return false;
        	}
        
        if(zip.indexOf('-') < 0 ) { tar_zip[0] = zip.substr(0,3);tar_zip[1] = zip.substr(3,4); }
        else tar_zip = zip.split('-');

		$.ajax({
        	type : 'get',
            url : zip_api + tar_zip[0] + '/' + tar_zip[1] + '.json',	 
            crossDomain : true,
            dataType : 'json',

            success : function(resp){
                    var obj = resp.data[0].ja; //戻り値のja部分を利用
                    
                    var address = '';
                    var state = '';
                    var city = '';
                     //市町村が別の場合

                    if((without_state != "all") && (obj.prefecture != state_text) ) state = obj.prefecture; //都道府県省略無し
                
                    if(state_field) record['record'][state_field]['value'] = state;
                    else address += state;
                            	           
                    if(city_field) record['record'][city_field]['value'] = obj.address1;
                    else address += obj.address1;

                    address += obj.address2 + obj.address3;
                                
                    if(company_field) record['record'][company_field]['value'] = obj.address4;
                    else address += obj.address4;
                    record["record"][addr_field]["value"] = address;
					kintone.app.record.set(record);
                    },
            
            error : function(resp){ //取得エラーの場合

                
                    if(state_field) record['record'][state_field]['value'] = "";
                            	           
                    if(city_field) record['record'][city_field]['value'] = "";

                    if(company_field) record['record'][company_field]['value'] = "";
                    record["record"][addr_field]["value"] = "";
					kintone.app.record.set(record);
                }
            
            });
	}
  
    // 詳細画面に郵便番号検索用のボタンを設置します
    function zipplus(event){
         
        // プラグインIDの設定
        var KEY = PLUGIN_ID;
         
        //設定値読み込み用変数
        var config = kintone.plugin.app.getConfig(KEY);
         
        //設定値読み込み
        if (!config) return false;
        zip_field = config["zip"];
        addr_field = config["addr"];
        state_field = config["state"];
        city_field = config["city"];
        company_field = config["company"];
        state_text = config["state_text"];
        without_state = config["without_state"];

		var btn_space = config["btn"];
        var btn_text = config["btn_text"];
        var newbuttonclass = "mmym-zipp-button";
        var oldbuttonclass = "mmym-zipp-button-old";
         
        //あらかじめ用意したスペースにボタンを配置する
		//スペース要素の取得
		var se = kintone.app.record.getSpaceElement(btn_space);
		if (!se) return false;
  
		//ボタンの作成
		var btn = document.createElement('button');
		btn.appendChild(document.createTextNode(btn_text));
		btn.id = "zipplus3"+KEY; //PLUGIN_IDでidをユニークに 
		btn.name = "zipplus3";
		se.appendChild(btn);
  
        if(config['newdesign']=="on") btn.className = newbuttonclass;//新デザインのスタイルに
		else btn.className = oldbuttonclass;
  
		$("#"+btn.id).click( zip_to_addr);
  
        return event;
  
    }
  
    // 登録・更新イベント(新規レコード、編集レコード、一覧上の編集レコード)
    kintone.events.on(['app.record.create.show',
                       'app.record.edit.show'], zipplus);
  
})(jQuery,kintone.$PLUGIN_ID);